/**
  ******************************************************************************
  * @file    main.c
  * @author  MCU Application Team
  * @brief   Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "py32t092xx_ll_Start_Kit.h"

/* Private define ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private user code ---------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static void APP_SystemClockConfig(void);
static void APP_ConfigTIM1Slave(void);
static void APP_ConfigTIM2Master(void);

/**
  * @brief  Main program.
  * @param  None
  * @retval int
  */
int main(void)
{
  /* Enable SYSCFG and PWR clock */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_SYSCFG);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);

  /* Enable TIM1,TIM2 clock */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_TIM1);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_TIM2);
  
  /* Configure system clock */
  APP_SystemClockConfig();

  /* Initialize LED */
  BSP_LED_Init(LED_GREEN);

  /* Initialize UART (for printf use) */
  BSP_UART_Config();

  /* Enable TIM1 */
  APP_ConfigTIM1Slave();
  
  /* Enable TIM2 */
  APP_ConfigTIM2Master();

  while (1)
  {
    printf("TIM1Count:%u\r\n",(unsigned int)LL_TIM_GetCounter(TIM1));
    LL_mDelay(1000);
  }
}

/**
  * @brief  Configure TIM2 as Master
  * @param  None
  * @retval None
  */
static void APP_ConfigTIM2Master(void)
{
  /* prescaler：8000 */
  LL_TIM_SetPrescaler(TIM2,8000-1);
  
  /* Counting mode: Up counting */
  LL_TIM_SetCounterMode(TIM2,LL_TIM_COUNTERMODE_UP);
  
  /* Auto-reload value : 1000-1 */
  LL_TIM_SetAutoReload(TIM2,1000-1);
  
  /* Clock no divider */
  LL_TIM_SetClockDivision(TIM2,LL_TIM_CLOCKDIVISION_DIV1);
  
  /* Set trigger output as UPDATE event */
  LL_TIM_SetTriggerOutput(TIM2,LL_TIM_TRGO_UPDATE);
  
  /* Enable TIM2 counter */
  LL_TIM_EnableCounter(TIM2);
}

/**
  * @brief  Configure TIM1 as Slave
  * @param  None
  * @retval None
  */
static void APP_ConfigTIM1Slave(void)
{
  /* Counting mode: Up counting */
  LL_TIM_SetCounterMode(TIM1,LL_TIM_COUNTERMODE_UP);
  
  /* Autoreload value：10 */
  LL_TIM_SetAutoReload(TIM1,10);
  
  /* Set trigger input as TIM2 */
  LL_TIM_SetTriggerInput(TIM1,LL_TIM_TS_ITR1);
  
  /* Set external clock mode 1 */
  LL_TIM_SetClockSource(TIM1,LL_TIM_CLOCKSOURCE_EXT_MODE1);
  
  /* Enable TIM1 */
  LL_TIM_EnableCounter(TIM1);
}

/**
  * @brief  Configure system clock
  * @param  None
  * @retval None
  */
static void APP_SystemClockConfig(void)
{
  /* Enable HSI */
  LL_RCC_HSI_Enable();
  while(LL_RCC_HSI_IsReady() != 1)
  {
  }

  /* Set AHB prescaler: HCLK = SYSCLK */
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_1);

  /* Select HSISYS as system clock source */
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_HSISYS);
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_HSISYS)
  {
  }

  /* Set APB prescaler: PCLK = HCLK */
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_1);
  LL_Init1msTick(8000000);

  /* Update the SystemCoreClock global variable(which can be updated also through SystemCoreClockUpdate function) */
  LL_SetSystemCoreClock(8000000);
}

/**
  * @brief  Error executing function.
  * @param  None
  * @retval None
  */
void APP_ErrorHandler(void)
{
  while (1)
  {
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* Users can add their own printing information as needed,
     for example: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* Infinite loop */
  while (1)
  {
  }
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
